% This fucntion compare the survival curves of two groups
% Inputs:
%       Data of group1 contains, survival times and cenor status
%       Data1(:,1) = is the survival time
%       Data1(:,2) = censor status (0 not censored, and 1 is censored)
%       Groups: the IDs of the groups to be compared
%       ColorMap: The defined colormap to be used in R.

function pvalue = Survival_TwoGroups(Data, Groups,ColorMap,currentFolder )

survivals = Data(:,1);
Censored = Data(:,2);
wdR = regexprep(currentFolder , '\\', '\\\');

%% Define an R Colormap based on the given groups
colmap = jet; close;
uq = unique(Groups);
l = length(uq);
ColorToR = 'c(';
for i=1:l
    v = uq(i);
    ColorToR = [ColorToR 'rgb(' sprintf('%s,%s,%s',num2str(colmap(ColorMap(v),1)),num2str(colmap(ColorMap(v),2)),num2str(colmap(ColorMap(v),3))), '),'];
    if(i == l)
        ColorToR(end) = ')';
    end
end
ColorToR
%%
openR;
evalR(['setwd("' wdR '")']);
evalR('library(survival)');

%% Survival analysis on components and assigned samples
putRdata('survtime',survivals);
putRdata('status',Censored);
putRdata('groups', Groups);
evalR('survobj <- Surv(survtime, as.integer(status))');
%evalR(['plot(survfit(survobj ~ groups), col=1:' num2str(length(unique(jdata.Var2))) ')']);
evalR('fit <- survfit(survobj ~ as.factor(groups))');
evalR('sdiff <- survdiff(survobj ~ as.factor(groups))');
evalR('pvalue <- as.numeric(format(signif(1 - pchisq(sdiff$chisq,length(sdiff$n)-1),3)))');
pvalue = getRdata('pvalue');
disp(pvalue);
evalR(['png("Groups_' num2str(uq(1)) '_' num2str(uq(2)) '.png")']);
%evalR(['postscript("0_KM_plot_k_' num2str(nr_of_components) '.eps")']);
evalR(['plot(fit, col=' ColorToR ', lwd=2)']);
evalR(['legend("topright", as.character(sort(unique(groups))), col=' ColorToR ', lty=1)']);
evalR('legend("bottomleft", paste("p =", pvalue))');
evalR('dev.off()');
closeR